function functionOutput = f(x)
% This is intended to be a black box function. Its final implementation
% will be done using a .p file so that it cannot be opened by the students.
%
% This black box function is constructed as follows: a piecewise function
% defined on some finite interval [a, b] composed for four different
% polynomials. Two of which are 1st and 2nd order, with the other two being
% polynomials of order greater than 3. This function should be positive
% within [a, b] and 0 elsewhere. It can be sampled at any point, x, between
% -Inf and +Inf.
%
% In this particular iteration, the function is loosely defined as follows:
%
%   f(x) --> 1st order   for x = [1, 3)
%   f(x) --> 4th order   for x = [3, 5)
%   f(x) --> 2nd order   for x = [5, 7)
%   f(x) --> 5th order   for x = [7, 9)
%   f(x) = 0 elsewhere

%Calculate polynomial coefficients (inefficient polyval implementation)
% c1 = polyfit([1 3], [0 4], 1);  %1st order
% c2 = polyfit([3 3.5 4 4.5 5], [4 7 3 9 3], 4);  %4th order
% c3 = polyfit([5 6 7], [3 4 10], 2);   %2nd order
% c4 = polyfit(linspace(7, 9, 6), [10 2.5 4.5 3.5 5.5 0], 5);   %5th order

%Calculate polynomial coefficients (efficient implementation by solving linear systems)
c1 = vander([1, 3])\[0 4]';  %1st order
c2 = vander([3 3.5 4 4.5 5])\[4 7 3 9 3]';  %4th order
c3 = vander([5 6 7])\[3 4 10]';  %2nd order
c4 = vander(linspace(7, 9, 6))\[10 2.5 4.5 3.5 5.5 0]';  %5th order

%Evaluate function within defined ranges
f1 = polyval(c1, x).*(x >= 1 & x < 3);
f2 = polyval(c2, x).*(x >= 3 & x < 5);
f3 = polyval(c3, x).*(x >= 5 & x < 7);
f4 = polyval(c4, x).*(x >= 7 & x <= 9);
felse = 0*(x < 1 | x > 9);

functionOutput = f1 + f2 + f3 + f4 + felse;

end

